﻿param(
    [String]$outputPath = ".\VCRuntime"
)
Write-Host "Download Microsoft Visual C++ 2005, 2008, 2010, 2012, 2013, 2015, 2017"
if(! (test-path "$outputPath\VS2005")) { New-Item "$outputPath\VS2005" -Type directory -Force}
Write-Verbose "Microsoft Visual C++ 2005 SP1 Redistributable Package (x86)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/8/B/4/8B42259F-5D70-43F4-AC2E-4B208FD8D66A/vcredist_x86.EXE" -OutFile "$outputPath\VS2005\vcredist_x86.exe"
Write-Verbose "Microsoft Visual C++ 2005 SP1 Redistributable Package (x64)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/8/B/4/8B42259F-5D70-43F4-AC2E-4B208FD8D66A/vcredist_x64.EXE" -OutFile "$outputPath\VS2005\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2008")) { New-Item "$outputPath\VS2008" -Type directory -Force }
Write-Verbose "Microsoft Visual C++ 2008 SP1 Redistributable Package (x86)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/5/D/8/5D8C65CB-C849-4025-8E95-C3966CAFD8AE/vcredist_x86.exe" -OutFile "$outputPath\VS2008\vcredist_x86.exe"
Write-Verbose "Microsoft Visual C++ 2008 SP1 Redistributable Package (x64)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/5/D/8/5D8C65CB-C849-4025-8E95-C3966CAFD8AE/vcredist_x64.exe" -OutFile "$outputPath\VS2008\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2010")) { New-Item "$outputPath\VS2010" -Type directory -Force }
Write-Verbose "Microsoft Visual C++ 2010 SP1 Redistributable Package (x86)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/1/6/5/165255E7-1014-4D0A-B094-B6A430A6BFFC/vcredist_x86.exe" -OutFile "$outputPath\VS2010\vcredist_x86.exe"
Write-Verbose "Microsoft Visual C++ 2010 SP1 Redistributable Package (x64)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/1/6/5/165255E7-1014-4D0A-B094-B6A430A6BFFC/vcredist_x64.exe" -OutFile "$outputPath\VS2010\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2012")) { New-Item "$outputPath\VS2012" -Type directory -Force }
Write-Verbose "Microsoft Visual C++ 2012 Update 4 Redistributable Package (x86)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU_4/vcredist_x86.exe" -OutFile "$outputPath\VS2012\vcredist_x86.exe"
Write-Verbose "Microsoft Visual C++ 2012 Update 4 Redistributable Package (x64)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/1/6/B/16B06F60-3B20-4FF2-B699-5E9B7962F9AE/VSU_4/vcredist_x64.exe" -OutFile "$outputPath\VS2012\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2013")) { New-Item "$outputPath\VS2013" -Type directory -Force }
Write-Verbose "Microsoft Visual C++ 2013 Redistributable Package (x86)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x86.exe" -OutFile "$outputPath\VS2013\vcredist_x86.exe"
Write-Verbose "Microsoft Visual C++ 2013 Redistributable Package (x64)" -Verbose
Invoke-WebRequest "http://download.microsoft.com/download/2/E/6/2E61CFA4-993B-4DD4-91DA-3737CD5CD6E3/vcredist_x64.exe" -OutFile "$outputPath\VS2013\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2015")) { New-Item "$outputPath\VS2015" -Type directory -Force }
Write-Verbose "Visual C++ Redistributable Update 3 for Visual Studio 2015 (x86)" -Verbose
Invoke-WebRequest "https://download.microsoft.com/download/6/D/F/6DF3FF94-F7F9-4F0B-838C-A328D1A7D0EE/vc_redist.x86.exe" -OutFile "$outputPath\VS2015\vcredist_x86.exe"
Write-Verbose "Visual C++ Redistributable Update 3 for Visual Studio 2015 (x64)" -Verbose
Invoke-WebRequest "https://download.microsoft.com/download/6/D/F/6DF3FF94-F7F9-4F0B-838C-A328D1A7D0EE/vc_redist.x64.exe" -OutFile "$outputPath\VS2015\vcredist_x64.exe"
if (! (test-path "$outputPath\VS2017")) { New-Item "$outputPath\VS2017" -Type directory -Force }
Write-Verbose "Visual C++ Redistributable for Visual Studio 2017 (x86)" -Verbose
Invoke-WebRequest "https://download.visualstudio.microsoft.com/download/pr/e9e1e87c-5bba-49fa-8bad-e00f0527f9bc/8e641901c2257dda7f0d3fd26541e07a/vc_redist.x86.exe" -OutFile "$outputPath\VS2017\vcredist_x64.exe"
Write-Verbose "Visual C++ Redistributable for Visual Studio 2017 (x64)" -Verbose
Invoke-WebRequest "https://download.visualstudio.microsoft.com/download/pr/36c5faaf-bd8b-433f-b3d7-2af73bae10a8/212f41f2ccffee6d6dc27f901b7d77a1/vc_redist.x64.exe" -OutFile "$outputPath\VS2017\vcredist_x64.exe"



param(
    [String]$outputPath = ".\VCRuntime"
)
 
[String]$outputPath = ".\VCRuntime"
 
Write-Host "Install Microsoft Visual C++ 2005, 2008, 2010, 2012, 2013, 2015, 2017"
 
foreach ($vcFile in Get-ChildItem $outputPath -Recurse -Filter "*.exe")
{
    Write-Host "Install " $vcFile.fullname
    Start-Process  $vcFile.fullname -ArgumentList '/q' -NoNewWindow -Wait
     
     
}
